# Google OAuth Setup Guide

## Overview
This application now supports Google OAuth for user authentication. Users can sign up and log in using their Google accounts.

## Setup Steps

### 1. Create Google OAuth Credentials

1. Go to the [Google Cloud Console](https://console.cloud.google.com/)
2. Create a new project or select an existing one
3. Enable the Google+ API (or Google Identity API)
4. Go to "Credentials" → "Create Credentials" → "OAuth 2.0 Client IDs"
5. Choose "Web application" as the application type
6. Add authorized redirect URIs:
   - `http://localhost:8000/auth/google/callback` (for local development)
   - `https://yourdomain.com/auth/google/callback` (for production)

### 2. Update Environment Variables

Add your Google OAuth credentials to your `.env` file:

```env
GOOGLE_CLIENT_ID=your_google_client_id_here
GOOGLE_CLIENT_SECRET=your_google_client_secret_here
GOOGLE_REDIRECT_URI=https://yourdomain.com/auth/google/callback
```

### 3. Features

- **New Users**: When a user signs up with Google, a new account is automatically created with:
  - Name from Google profile
  - Email from Google profile (pre-verified)
  - A new wallet with $0 balance
  - Random secure password

- **Existing Users**: If a user with the same email already exists, they are automatically logged in

- **Security**: Only non-admin users can be created through Google OAuth

### 4. Routes

- `GET /auth/google` - Redirects to Google OAuth
- `GET /auth/google/callback` - Handles Google OAuth callback

### 5. Testing

1. Ensure your Google OAuth credentials are properly configured
2. Visit the login or register page
3. Click "Continue with Google"
4. Complete the Google OAuth flow
5. Verify that you're redirected to the appropriate page

## Troubleshooting

- **"Google authentication failed"**: Check your Google OAuth credentials and redirect URI
- **Redirect URI mismatch**: Ensure the callback URL in Google Console matches your environment variable
- **API not enabled**: Make sure Google+ API or Google Identity API is enabled in your Google Cloud project

## Security Notes

- Google users are automatically email-verified
- Random passwords are generated for OAuth users
- Admin users cannot be created through Google OAuth
- All OAuth operations are wrapped in database transactions for data integrity
